"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLinuxToolsPath = getLinuxToolsPath;
exports.prefetchBuildTools = prefetchBuildTools;
exports.fpmPath = void 0;

function _binDownload() {
  const data = require("builder-util/out/binDownload");

  _binDownload = function () {
    return data;
  };

  return data;
}

function _lazyVal() {
  const data = require("lazy-val");

  _lazyVal = function () {
    return data;
  };

  return data;
}

var path = _interopRequireWildcard(require("path"));

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; return newObj; } }

function getLinuxToolsPath() {
  //noinspection SpellCheckingInspection
  return (0, _binDownload().getBinFromGithub)("linux-tools", "mac-10.12.3", "SQ8fqIRVXuQVWnVgaMTDWyf2TLAJjJYw3tRSqQJECmgF6qdM7Kogfa6KD49RbGzzMYIFca9Uw3MdsxzOPRWcYw==");
}

const fpmPath = new (_lazyVal().Lazy)(() => {
  if (process.platform === "win32" || process.env.USE_SYSTEM_FPM === "true") {
    return Promise.resolve("fpm");
  }

  return (0, _binDownload().getBin)("fpm", "fpm", null).then(it => path.join(it, "fpm"));
}); // noinspection JSUnusedGlobalSymbols

exports.fpmPath = fpmPath;

function prefetchBuildTools() {
  // yes, we starting to use native Promise
  return fpmPath.value;
} 
//# sourceMappingURL=tools.js.map