"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getGypEnv = getGypEnv;
exports.rebuild = exports.installOrRebuild = void 0;

function _bluebirdLst() {
  const data = _interopRequireWildcard(require("bluebird-lst"));

  _bluebirdLst = function () {
    return data;
  };

  return data;
}

function _builderUtil() {
  const data = require("builder-util");

  _builderUtil = function () {
    return data;
  };

  return data;
}

function _fs() {
  const data = require("builder-util/out/fs");

  _fs = function () {
    return data;
  };

  return data;
}

function _os() {
  const data = require("os");

  _os = function () {
    return data;
  };

  return data;
}

var path = _interopRequireWildcard(require("path"));

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; return newObj; } }

let installOrRebuild = (() => {
  var _ref = (0, _bluebirdLst().coroutine)(function* (config, appDir, options, forceInstall = false) {
    const effectiveOptions = Object.assign({
      buildFromSource: config.buildDependenciesFromSource === true,
      additionalArgs: (0, _builderUtil().asArray)(config.npmArgs)
    }, options);

    if (forceInstall || !(yield (0, _fs().exists)(path.join(appDir, "node_modules")))) {
      yield installDependencies(appDir, effectiveOptions);
    } else {
      yield rebuild(appDir, effectiveOptions);
    }
  });

  return function installOrRebuild(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
})();

exports.installOrRebuild = installOrRebuild;

function getElectronGypCacheDir() {
  return path.join((0, _os().homedir)(), ".electron-gyp");
}

function getGypEnv(frameworkInfo, platform, arch, buildFromSource) {
  const npmConfigArch = arch === "armv7l" ? "arm" : arch;
  const common = Object.assign({}, process.env, {
    npm_config_arch: npmConfigArch,
    npm_config_target_arch: npmConfigArch,
    npm_config_platform: platform,
    npm_config_build_from_source: buildFromSource,
    // required for node-pre-gyp
    npm_config_target_platform: platform,
    npm_config_update_binary: true,
    npm_config_fallback_to_build: true
  });

  if (platform === "win32") {
    common.npm_config_target_libc = "unknown";
  }

  if (!frameworkInfo.useCustomDist) {
    return common;
  } // https://github.com/nodejs/node-gyp/issues/21


  return Object.assign({}, common, {
    npm_config_disturl: "https://atom.io/download/electron",
    npm_config_target: frameworkInfo.version,
    npm_config_runtime: "electron",
    npm_config_devdir: getElectronGypCacheDir()
  });
}

function installDependencies(appDir, options) {
  const platform = options.platform || process.platform;
  const arch = options.arch || process.arch;
  const additionalArgs = options.additionalArgs;

  _builderUtil().log.info({
    platform,
    arch,
    appDir
  }, `installing production dependencies`);

  let execPath = process.env.npm_execpath || process.env.NPM_CLI_JS;
  const execArgs = ["install", "--production"];

  if (!isYarnPath(execPath)) {
    if (process.env.NPM_NO_BIN_LINKS === "true") {
      execArgs.push("--no-bin-links");
    }

    execArgs.push("--cache-min", "999999999");
  }

  if (execPath == null) {
    execPath = getPackageToolPath();
  } else {
    execArgs.unshift(execPath);
    execPath = process.env.npm_node_execpath || process.env.NODE_EXE || "node";
  }

  if (additionalArgs != null) {
    execArgs.push(...additionalArgs);
  }

  return (0, _builderUtil().spawn)(execPath, execArgs, {
    cwd: appDir,
    env: getGypEnv(options.frameworkInfo, platform, arch, options.buildFromSource === true)
  });
}

function getPackageToolPath() {
  if (process.env.FORCE_YARN === "true") {
    return process.platform === "win32" ? "yarn.cmd" : "yarn";
  } else {
    return process.platform === "win32" ? "npm.cmd" : "npm";
  }
}

function isYarnPath(execPath) {
  return process.env.FORCE_YARN === "true" || execPath != null && path.basename(execPath).startsWith("yarn");
}
/** @internal */


let rebuild = (() => {
  var _ref2 = (0, _bluebirdLst().coroutine)(function* (appDir, options) {
    const nativeDeps = yield _bluebirdLst().default.filter((yield options.productionDeps.value), it => (0, _fs().exists)(path.join(it.path, "binding.gyp")), {
      concurrency: 8
    });

    if (nativeDeps.length === 0) {
      _builderUtil().log.info("no native production dependencies");

      return;
    }

    const platform = options.platform || process.platform;
    const arch = options.arch || process.arch;
    const additionalArgs = options.additionalArgs;

    _builderUtil().log.info({
      platform,
      arch
    }, "rebuilding native production dependencies");

    let execPath = process.env.npm_execpath || process.env.NPM_CLI_JS;
    const isYarn = isYarnPath(execPath);
    const execArgs = [];

    if (execPath == null) {
      execPath = getPackageToolPath();
    } else {
      execArgs.push(execPath);
      execPath = process.env.npm_node_execpath || process.env.NODE_EXE || "node";
    }

    const env = getGypEnv(options.frameworkInfo, platform, arch, options.buildFromSource === true);

    if (isYarn) {
      execArgs.push("run", "install");

      if (additionalArgs != null) {
        execArgs.push(...additionalArgs);
      }

      yield _bluebirdLst().default.map(nativeDeps, dep => {
        _builderUtil().log.info({
          name: dep.name
        }, `rebuilding native dependency`);

        return (0, _builderUtil().spawn)(execPath, execArgs, {
          cwd: dep.path,
          env
        }).catch(error => {
          if (dep.optional) {
            _builderUtil().log.warn({
              dep: dep.name
            }, "cannot build optional native dep");
          } else {
            throw error;
          }
        });
      }, {
        concurrency: process.platform === "win32" ? 1 : 2
      });
    } else {
      execArgs.push("rebuild");

      if (additionalArgs != null) {
        execArgs.push(...additionalArgs);
      }

      execArgs.push(...nativeDeps.map(it => `${it.name}@${it.version}`));
      yield (0, _builderUtil().spawn)(execPath, execArgs, {
        cwd: appDir,
        env
      });
    }
  });

  return function rebuild(_x4, _x5) {
    return _ref2.apply(this, arguments);
  };
})(); exports.rebuild = rebuild;
//# sourceMappingURL=yarn.js.map