export declare type ElectronPlatformName = "darwin" | "linux" | "win32" | "mas";
export interface ElectronDownloadOptions {
    version?: string;
    /**
     * The [cache location](https://github.com/electron-userland/electron-download#cache-location).
     */
    cache?: string | null;
    /**
     * The mirror.
     */
    mirror?: string | null;
    /** @private */
    customDir?: string | null;
    /** @private */
    customFilename?: string | null;
    quiet?: boolean;
    strictSSL?: boolean;
    isVerifyChecksum?: boolean;
    /** @private */
    force?: boolean;
    platform?: ElectronPlatformName;
    arch?: string;
}
export declare function downloadElectron(options: ElectronDownloadOptions): Promise<string>;
