# Surface Mounted Lights

The stock light parts are designed to light the distant objects. However, the station itself needs some lighting to be usable when passing thru the dark side of the celestial body. The lighting parts in this mod are designed to highlight the surface, on which they are mounted.

# Omni Light

Illuminates a small area on the vessel's surface.
![Omni Light](https://github.com/ihsoft/SurfaceLights/raw/master/WikiImages/OmniLight-demo.png)

# Spot Light
Illuminate the parts and objects at a small distance.
![Spot Light](https://github.com/ihsoft/SurfaceLights/raw/master/WikiImages/SpotLight-demo.png)

# 4Way Spot light
A special version of the spot light that emits light in 4 perpendicular directions. Each light can be adjusted and controlled independently.
![Spot Light](https://github.com/ihsoft/SurfaceLights/raw/master/WikiImages/4WaySpotLight-demo.png)

# Features

* The stock lights get an ability to change the lens color. It make them looking much cooler.
![Illuminator Mk1](https://github.com/ihsoft/SurfaceLights/raw/master/WikiImages/Mk1-lens-demo.png) ![Illuminator Mk2](https://github.com/ihsoft/SurfaceLights/raw/master/WikiImages/Mk2-lens-demo.png)
* All light parts, including the stock ones, can be adjusted in flight when EVA. The following properties can be adjusted:
  - On/OFF status. Even if the vessel that owns the part is not controllable.
  - Color of the light.
  - The light part lens intensity. __In Adwanced Tweakables mode only__.
  - The spotlight angle. __In Adwanced Tweakables mode only__.
  - The light range. __In Adwanced Tweakables mode only__.

# Demo media

* [VIDEO: Overview of the EVA capabilities](https://youtu.be/tu6VmhfeBnE).

\* _The videos above were created using the pre-release versions of SurfaceLights. Real appearance may differ_.

# Languages supported

![Русский](https://github.com/ihsoft/SurfaceLights/raw/master/WikiImages/Russian-small-flag.png) Русский

![Italiano](https://github.com/ihsoft/SurfaceLights/raw/master/WikiImages/Italian-small-flag.png) Italiano

![Español](https://github.com/ihsoft/SurfaceLights/raw/master/WikiImages/Spanish-small-flag.png) Español

![Português](https://github.com/ihsoft/SurfaceLights/raw/master/WikiImages/Brazil-small-flag.png) Português

# Support

You can support this and the other of my mods on [Patreon](https://www.patreon.com/ihsoft). This is where I post my ideas, prototypes and the features development progress.

# How to install

* _Recommended_:
    * Install and run [CKAN](https://github.com/KSP-CKAN/CKAN/releases).
    * Search for "Surface Mounted Lights", then install the mod.
    * Occasionally run CKAN client to update the mod to the latest version.
* Manual:
    * Download the ZIP archive:
        * From [CurseForge](https://kerbal.curseforge.com/projects/surface-mounted-stock-alike-lights-for-self/files).
        * From [Spacedock](https://spacedock.info/mod/1911/Surface%20Mounted%20Lights).
        * From [GitHub](https://github.com/ihsoft/SurfaceLights/releases).
     * If you have an older version of the mod in your game, you __must__ delete all the old files first! __Do not just copy over__, this will likely result in compatibility issues.
     * Unzip the release archive into the game's `GameData` folder.
        * Note, that names of the folders __must__ be exactly like in the archive or the mod __won't work__.
		* The release archive contains a minimum version of the required dependency: `ModuleManager`. If your game has better versions, do not overwrite!
    * Verify the installation: the mod's `LICENSE.md` file must be located at `<game root>/GameData/SurfaceLights/LICENSE.md`.

# Forum

Ask questions and propose suggestions on
[the forum](https://forum.kerbalspaceprogram.com/index.php?/topic/139724-16-surface-mounted-lights-v110/).

# Development

To start your local building environment read [BUILD.md](https://github.com/ihsoft/SurfaceLights/blob/master/BUILD.md).

If you're going to make a pull request, please, read [the code rules](https://github.com/ihsoft/SurfaceLights/blob/master/Source/README.md) first.
Changes that don't follow the rules will be **rejected**.
