﻿# Easy Vessel Switch (EVS)

The stock game doesn't care much about the camera stabilization when you switch between the vessels. You can walk in EVA, enter a pod, and end up with a camera looking in the sky. Or you may want to take a closer look at some part of your big station, but the camera focus is
bound to the station's center of mass, and the part of the interest is far away form it.

This mod can help you solving these troubles! With EVS:

* ...the camera will stop jumping around randomly. There are two modes of stabilization that allow preserving the view in the scene (switch with `F7`)...
* ...you're able to focus the view on any part of any vessel with a simple mouse click (with `O` hold, it's configurable)...
* ...a new active vessel can be selected by simply holding `ALT` (configurable) and clicking on the vessel you like...
* ...the basic info of a vessel can be quickly seen by simply hovering over it (with `ALT` hold)...

And this mod speaks 4 major languages in case of some of your kerbals are picky in this sense.

# Demo media

* [VIDEO: Mod overview + tutorial](https://www.youtube.com/watch?v=AKOtPQSLfRY)
* [VIDEO: The part focus feature](https://www.youtube.com/watch?v=Lb1KB8hSrw8)

# Languages supported

![Русский](https://github.com/ihsoft/EasyVesselSwitch/raw/master/WikiImages/Russian-small-flag.png) Русский

![Italiano](https://github.com/ihsoft/EasyVesselSwitch/raw/master/WikiImages/Italian-small-flag.png) Italiano

![Español](https://github.com/ihsoft/EasyVesselSwitch/raw/master/WikiImages/Spanish-small-flag.png) Español

![简体中文](https://github.com/ihsoft/EasyVesselSwitch/raw/master/WikiImages/Chineese-small-flag.png) 简体中文

![Français](https://github.com/ihsoft/EasyVesselSwitch/raw/master/WikiImages/French-small-flag.png) Français

# Support

You can support this and the other of my mods on [Patreon](https://www.patreon.com/ihsoft). This is where I post my ideas, prototypes and the features development progress.

# Other useful mods for EVA

If you want doing EVA comfortably, you really should consider adding these mods as well:

* [Kerbal Inventory System (KIS)](https://forum.kerbalspaceprogram.com/index.php?/topic/149848-14-kerbal-inventory-system-kis-v114/). Now you can build and upgrade vessels in EVA!
* [Kerbal Attachment System (KAS)](https://github.com/ihsoft/KAS). Need to link two vessels? Just send out your kerbals EVA! Don't forget to update their inventories, though.
* [Surface Mounted Lights](https://github.com/ihsoft/SurfaceLights). Too dark for EVA on the other side of the moon? Problem solved with these ambient lights!

# How to install

* _Recommended_:
  * Install and run [CKAN](https://github.com/KSP-CKAN/CKAN/releases).
  * Search for "Easy Vessel Switch" or just "EVS", then install the mod.
  * Occasionally run CKAN client to update EVS (and other mods) to the latest version.
  * If you follow this path, then all the EVS dependencies will be updated _automatically_. It may save you a lot of time during the update.
* Manual:
  * Download the ZIP archive:
    * From [CurseForge](https://kerbal.curseforge.com/projects/easy-vessel-switch-evs/files).
    * From [Spacedock](https://spacedock.info/mod/1906/Easy%20Vessel%20Switch).
    * From [GitHub](https://github.com/ihsoft/EasyVesselSwitch/releases).
  * If you have an older version of the mod in your game, you __must__ delete all the old files first! __Do not just copy over__, this will likely result in compatibility issues.
  * Unzip the release archive into the game's `GameData` folder.
    * Note, that names of the folders __must__ be exactly like in the archive or the mod __won't work__.
  * Verify the installation: the mod's `LICENSE.md` file must be located at `<game root>/GameData/EVS/LICENSE.md`.

# Forum

Ask questions and propose suggestions on
[the forum](http://forum.kerbalspaceprogram.com/index.php?/topic/141180-12-easy-vessel-switch-evs-v120/).

# Development

To start your local building environment read [BUILD.md](https://github.com/ihsoft/EasyVesselSwitch/blob/master/BUILD.md).

If you're going to request a pull request, please, read [code rules](https://github.com/ihsoft/EasyVesselSwitch/blob/master/Source/README.md) first.
Changes that don't follow the rules will be **rejected**.
