WhirligigWorld Planetary System: Absurd Homeworld in an Alien Solar System.

![https://i.imgur.com/xX4qSTM.png](https://i.imgur.com/xX4qSTM.png)

WhirligigWorld is a mod which moves the Kerbal Space Center to the equator of Mesbin, a rapidly spinning supermassive airless planet. The solar system is also completely rebuilt, turning it into the Kaywell/Gememma binary star system.

**Credits:**

Lead Developer:
* GregroxMun (Art, design, and configuration) Donate at https://www.patreon.com/Gregrox

Mod Help:
* Thomas P. and the Kopernicus Team
* Thomas P., MrHappyFace, Sigma88 (Kopernicus Expansion Continued)
* SeveredSolo (ModuleCommandLimitedControl Plugin)
* NovaSilisko (Feedback, playtesting, the model for the Kaputnik Mk0 Electromechanical Program Executor)
* SnailsAttack (Feedback, playtesting, Totooa and Yeerbor Biome Map, Revamped minor moon Mally ~~because I couldn't be bothered~~)
* Exo (Revamped dwarf planet Pragnik)
* Shamash_D (Feedback, playtesting, livestreaming)
* Tutur (Feedback, playtesting)

External Resources:
* SnowfallTheCat (Venus cloud map, used on Derbin)
* Carl Davidson (Tectonics.js web app, used for some heightmaps)

Inspiration:
* Hal Clement (Author of the novel *Mission of Gravity* and the essay *Whirligig World*, both classic works of hard-sci-fi worldbuilding.)
* Chris Wayan (Creator of Lyr and Oisin, the basis for Valyr and Oshan, and very creative planetary worldbuilder.)
* Winchell Chung "Nyrath" (Whose Atomic Rockets web page on the Worldbuilding of Mesklin really started off my obsession with these oblate worlds. I am proud to say that section now contains info about my Whirligig World mod, found at http://www.projectrho.com/public_html/rocket/worldbuilding.php#mesbin)

----------------IMPORTANT COMPATIBILITY NOTICE--------------------

Make sure, when updating the mod, you delete the old WhirligigWorld folder before you install the new one.
Also, make sure you are using the latest version of Kopernicus. (or latest backport if you're playing on old KSP)

------------------------------------------------------------------

LICENSE

Whirligig World art assets and config files: Copyright Gregory Brannon (GregroxMun) 2018. All Rights Reserved.

Kopernicus Expansion Continued: GNU General Public License.

Sigma Loading Screens: Copyright Sigma88, used with explicit permission.

Derbin cloud map: JAXA Venus Data. Map is copyright Snowfall-The-Cat 2018. "Use this however you like, just give me a credit if possible for assembling." https://www.deviantart.com/snowfall-the-cat/art/Venus-Clouds-733625463

ModuleCommandLimitedControl: MIT License Copyright (c) 2020 severedsolo

SciRev: MIT License Copyright (c) 2019 Dorian Stoll

Loading Art: Copyright (c) 2019 Pythania.


------------------------------------------------------------------

PLUGIN SOURCE

SciRev: https://github.com/StollD/SciRev

Kopernicus Expansions Continued: https://github.com/StollD/KopernicusExpansion-Continued

ModuleCommandLimitedControl: https://github.com/severedsolo/ModuleCommandLimitedControl

Sigma-LoadingScreens: https://github.com/Sigma88/Sigma-LoadingScreens

------------------------------------------------------------------

BACKSTORY

Around 1300 years ago, explorers from the far off planet Kerbin left their home to colonize other star systems. One such ship embarked on a journey to Kerbmun, an oxygenated moon in the Kaywell star system. There was just one problem. They hadn't counted on Mesbin being much wider than expected.

Unable to correct their course due to piloting error, the U.S.C. Manifest Destiny crashed into the massive, 70 Kerbin Mass planet Mesbin. Luckily, Mesbin spins. Once every twenty eight minutes it completes a rotation, and the centripetal effect pushes the equator outwards and negates some of the gravity. The 13 gees of gravity at the poles is reduced to a tad under 1.3 gee at the equator.

The payload of the ship survived, but the engines and fuel tanks were reduced to a lot of metal rubble along the surface. Unable to find somewhere else to go, they buried themselves underground and set up a stable ecosystem and environment. It took nearly two millenia, a few wars, and the re-invention of the steam engine, but eventually the colony was sufficiently industrialized to start looking up again.

------------------------------------------------------------------

MESBIN PHYSICAL CHARACTERISTICS

* MASS = 3.777e24 kg = 71.38 MKerbin
* POLAR RADIUS = 1,392,609 m = 2.32 RKerbin
* EQUATORIAL RADIUS = 2,367,436 m = 3.95 RKerbin
* SPHERICAL DENSITY = 136 g/cm^3 = 2.344 ρKerbin
* POLAR GRAVITY = 13.2 G
* TRUE EQUATORIAL GRAVITY = 4.58 G
* APPARENT EQUATORIAL GRAVITY = 1.286 G
* ROTATION PERIOD = 1701 s (28 minutes.)

------------------------------------------------------------------

List of objects: (Descriptions intentionally vague.)

Kaywell: A white main sequence star.
* Limnel: A red dwarf star in a close binary with Kaywell.
* Shol: A Hot Jupiter orbiting close to Kaywell.
* 2 Wolda: A small asteroid orbiting terrifyingly close to Shol.
* Tyepolbynar: A warm Jupiter that gets more light than Venus.
    * Jifgif: Small minor moon.
    * Imterril: Big blue moon.
    * Tannor: White moon.
    * Etrograd: Gray, retrograde moon.
    * Aerious: Small minor moon in a potentially chaotic orbit.
* 1 Wers: A large asteroid, or perhaps a small dwarf planet.
    * 1 Vizea: Wers' moon, which is so bright compared to Wers that' it's been argued Vizea was discovered first.
* Mesbin: An oblate airless world with a rotation period of 28 minutes, gravity of 13 gees at the poles, and 1.3 at the equator.
    * Statmun: Tiny, dense moon in a Mesbin-Stationary orbit.
    * Thresomin: MINor moon in a THree to one RESOnance.
    * Graymun: Gray moon.
    * Kerbmun: Very Kerbin-like moon.
    * Troymin: TROjan MINor moon of Kerbmun.
    * Derbin: Superterrestrial-mass planet in a distant binary orbit with Mesbin.
        * Derminmus: Largish minor submoon with a similar spectral type as Minmus.
		* Dermun: Large submoon superficially similar to Graymun.
* Valyr: Superterrestrial-mass ocean world.
    * Denna: Greenish minor moon.
    * Plaph: Brownish minor moon.
    * Oshan: Large, cold, white and red.
    * Manonam: Distant cold moon.
        * Didd: Subsatellite of Manonam.
* Egad: A medium-sized desert world.
    * Yeerbor: Captured asteroid in an eccentric orbit.
* 3 Rik: Main Belt asteroid.
* Reander: A jovian-type gas giant.
    * Lito: Enormous earth-mass ice moon.
    * Yalthe: Little hot moon.
    * Yokane: Little warm moon.
    * Dakkon: Little white moon.
    * Totoöa: Little atmospheric moon.
    * Mally: Trojan of Totoöa.
    * Yawer: This moon seems to blink on and off every hour or so.
* 1P/Fophie: A short period comet rising high above the plane of the Kaywell system.

Gememma: A red dwarf star.
* Ammenon: Little planet close to Gememma.
* Lowel: Planet known to be in Gememma's habitable zone.
    * Ollym: The massive binary companion of Lowel.
* Gannovar: Icy world in an eccentric orbit of Gememma.
* G1 Gallant: Large asteroid.
* Mandrake: A large blue ice giant planet.
    * Rutherford: A small blue ice giant planet, binary with Mandrake.
    * Lozon: You must face the little moon.
    * Beagrid: A mother's little moon.
    * Jancy: Dirty little moon.
    * Tatian: I see a little moon.
* Pragnik: Dwarf planet in Plutino-resonance with Mandrake & Rutherford.

------------------------------------------------------------------

CAREER AND SCIENCE MODE NOTES:

* It is refreshing to play in this system if you're already used to career mode.
* You should definitely try this in career mode--I've had a lot of fun with this!
* The tech tree has been reconfigured to make more sense: 
    * The tall rocket tanks for Size 1 and Size 1.5 are unlocked at the same time as the short tanks.
    * Aviation sub-tree is moved one space to the right, unlocking later and requiring more science for each node.
    * Field Science Node is now where Aviation was before--rovers before planes!
    * Science cost and node connections have been rearranged appropriately to fit.
    * Changed Survivability from basic landing parts to the first antennas and some probe bits and renamed it "Safety Equipment". It's survivable because now you can use robots instead of kerbals.
    * Changed Stability icon from a winglet to the flight control icon, along with a few other icon changes.
    * Landing node now contains the small parachute, the radial drogue chute, and the radial parachute, as well as all heat shields up to 2.5m.
    * Unlock monopropellant and the linear RCS thruster in Stability.
    * Both the radial decoupler and the 1.25m decoupler are unlocked in tier 2: Basic Rocketry and Engineering 101 respectively.
    * Thermometer and Mystery Goo swap places.
    * Barometer is unlocked earlier--and rebranded as AtMoCo surplus cavern pressure sensors from a cave-city that lost all its air due to a tragic mistake.
    * Added the Kaptunik, which is very heavy and lacks the internal antenna, BUT it does have full SAS autopilot (Prograde/Retrograde, Radial In/Out, Antinormal/Normal, Full Thrust/Cut Thrust, and Stage.) When you unlock the antenna you of course get all of that and manual control, but it's still really heavy.
    * The small ISRU parts are unlocked earlier, so you can take advantage of mining asteroids earlier on.
    * Pods and Lander Cans have been swapped around.
    * Tricoupler and Bicoupler are unlocked early on as well.
* Making History compatible, partially compatible with other mods.
* All transmitter parts now have 2 times the range.
* All bodies have biome maps, some more detailed than others.
* Most worlds have fairly detailed science descriptions. (Though writing dozens of experiements for many biomes on 50 bodies necessarily means not every world and situation will be as fleshed out as possible)
* The atmosphere analysis experiment will simply display the atmospheric composition that was used to generate atmosphere curves.
* Science has been balanced such that the total amount of science available in the system is greater than the stock system, but each individual celestial body is worth less science than their stock equivalents.

These changes only affect the Mesbin homeworld option.

------------------------------------------------------------------

KAPUTNIK PROBE CORE:

The Kaputnik Mk0 Electromechanical Program Executor and Four-Function Calculator! A start-level probe core designed by me and modeled by NovaSilisko that is 1.875m diameter (1.25m mounting points), very heavy, and contains all SAS levels. However, there's no transmitter/reciever, so the probe core can *only* use SAS for control until you unlock the antenna. Even when you do finally get the antenna and full control over the vehicle, and therefore have all the functionality of the top tier probe cores, you still have to lug that functionality around in a 1.2 ton mass of vacuum tubes, wires, metal gears and cogs.

------------------------------------------------------------------

KNOWN ISSUES:

* Kaywell and Gememma can be seen behind the equatorial bulge of Mesbin. This is inherent stock behavior--look for the sun lens flare behind a lump on Gilly or Bop.
* Mesbin has an atmosphere that goes all the way up past the equatorial bulge. It is not functional, but is required for making engines work (Isp scaling) and for Career mode contracts. As of 0.10.0, the extra height can be disabled in a settings file, at the expense of ruining the first few contracts.
* Mesbin's shape is also not accurate to what the game insists is "down" as far as the camera works. So the middle latitudes will always appear to slope much more than their effective gravity would imply.
* There are some issues with reparenting Kerbin using Kerbmun Homeworld swap. The orbit of the planet may appear to wander, and the Space Center scene will never be accurate.
* EVE-Redux Emissives are currently broken.
------------------------------------------------------------------

KERBMUN HOMEWORLD SWAP

There is a settings file that allows you to relocate the KSC to the surface of Kerbmun instead of Mesbin. I don't know *why* you would want to (since Mesbin is so dang cool), but just in case you're feeling homesick but want to play with the Kaywell system, this is an option. To use it, follow these instructions:

1 Open the file GameData/WhirligigWorld/Settings.cfg in a text editor.

2 You will see a configuration string with "Homeworld = Mesbin"

3 Change "Mesbin" to "Kerbmun"

4 Restart KSP, and make sure to use a new save file or at least back up your old one.

5 Kerbmun is nearly identical to Kerbin, though slightly denser. Gameplay will be comparable to Alternis Kerbol or Laythe Space Program.

------------------------------------------------------------------

REQUIRED MODS (The game will not work without these)

1) The latest version of Kopernicus.
Make sure you install the plugin's own prerequisites, which come bundled along: ModularFlightIntegrator and ModuleManager.

Forum Thread: https://forum.kerbalspaceprogram.com/index.php?/topic/181547-170-1-backports-kopernicus-kittopiatech/

2) Scientific Revolution (bundled with Whirligig World download)

GitHub Repository: https://github.com/StollD/SciRev

----------------------------

STRONGLY RECOMMENDED (and supported) MODS

Scatterer. Configs included. Supports scatterer atmospheres for all relevant worlds except Derbin and the Gas Giants. Supports eclipse casting from all relevant worlds orbiting Kaywell.
* Forum Thread: https://forum.kerbalspaceprogram.com/index.php?/topic/103963-wip19x-110x-111x-scatterer-atmospheric-scattering-v00723-31122020/

Environmental Visual Enhancements-Redux. Plugin only, do not install any E.V.E. visual-packs/configs or "BoulderCo". Supports clouds for all atmospheric planets, most importantly on Imterril and Derbin.
* Forum Thread: https://forum.kerbalspaceprogram.com/index.php?/topic/196411-19-111x-eve-redux-performance-enhanced-eve-maintenance-v11121-31012021/

Distant Object Enhancement. Adds dots of the correct colors to represent distant planets and moons in the sky.
* Forum Thread: https://forum.kerbalspaceprogram.com/index.php?/topic/89214-13x-14x-distant-object-enhancement-bis-v191-8-july-2017/

PlanetShine. Adds a subtle lighting effect to simulate reflected light coming from a planet's surface, cast onto spacecrafts. Supports correct colors.
* Forum Thread: https://forum.kerbalspaceprogram.com/index.php?/topic/173138-141-planetshine-0261-mar-28-2018/

Poodmund's Deep Star Map Skybox. A fantastic realistic skybox that I consider to be the canonical appearance (at least for now) of Mesbin's skies.
* Forum Post: https://forum.kerbalspaceprogram.com/index.php?/topic/96851-15x-texturereplacer-34-28102018/&page=42&tab=comments#comment-2388097

Sigma EditorView. Beautiful suffocating view of the vast night sky as seen in the VAB and SPH.
* GitHub Repository: https://github.com/Sigma88/Sigma-EditorView/releases

(ResearchBodies). Delays the discovery of certain celestial bodies during the game.
* Forum Thread: https://forum.kerbalspaceprogram.com/index.php?/topic/139473-141-researchbodies-v197-17th-mar-2018/

(Kronometer). I have invented my own basic calendar/clock for WhirligigWorld, since days and years don't exactly have the same meaning anymore.
* GitHub Repository: https://github.com/StollD/Kronometer/releases/tag/v1.3.1-2
* Explanation link: https://github.com/GregroxMun/aWhirligigWorld/wiki/Kronometer-Support-and-The-Mesbin-General-Calendar

(Community Tech Tree). Tech tree modifications are safely applied to the CTT.
* Forum Thread: https://forum.kerbalspaceprogram.com/index.php?/topic/90530-15x-community-tech-tree-oct-16/

(Extraplanetary Launchpads). I don't use or recommend this, but I do include patches to exclude MetalOre from spawning on the gas giants and some icy worlds, while making Statmun have even more MetalOre.
* Forum Thread: https://forum.kerbalspaceprogram.com/index.php?/topic/54284-173-extraplanetary-launchpads-v661/

(Bluedog Design Bureau). Science instruments are supported.
* Forum Thread: https://forum.kerbalspaceprogram.com/index.php?/topic/122020-181-1112-bluedog-design-bureau-stockalike-saturn-apollo-and-more-v172-%D0%BE%D0%B3%D1%80%D0%BE%D0%BC%D0%BD%D1%8B%D0%B9-22mar2021/

----------------------------

OTHER USEFUL MODS (that are neither supported nor broken by WW)

The entire Near Future Suite, but in particular:
Near Future Exploration. Adds multiple large antenna systems for communication with the outer system, implemented in a unique and interesting way. Also lots of cool probe bodies to play with.
Near Future Electrical. Adds nuclear reactors to allow for power generation in the outer system. Pairs well with Near Future Propulsion.
Near Future Launch Vehicles. Giant rockets for a giant planet.
* Forum Thread: https://forum.kerbalspaceprogram.com/index.php?/topic/155465-111x-near-future-technologies-all111x/

Cryogenic Engines. Energetic upper stages are good news for getting things out of Mesbin's deep gravity well.
* Forum Thread: https://forum.kerbalspaceprogram.com/index.php?/topic/106089-145-cryogenic-engines-high-isp-chemical-rockets-august-7/

Kerbal Atomics. High efficiency and high thrust nuclear thermal rocket engines are kind of OP--except when you're trying to escape Mesbin's gravity well!
* Forum Thread: https://forum.kerbalspaceprogram.com/index.php?/topic/130503-145-kerbal-atomics-fancy-nuclear-engines-august-7/

Eve Optimized Engines. Not useful for launching from Mesbin, but there are several destination planets with thick atmospheres that this may come in handy for.
* Forum Thread: https://forum.kerbalspaceprogram.com/index.php?/topic/136342-14x-13x-eve-optimized-engines/

Transfer Window Planner. There is currently no delta-v chart (and probably won't be until I finalize the system design in 1.0). This mod is a lovely alternative, with plenty of information on transfer times and delta-v.
* Forum Thread: https://forum.kerbalspaceprogram.com/index.php?/topic/84005-14x-transfer-window-planner-v1630-march-18/

Kerbal Engineer Redux. You should know what this does already! It's as useful here as ever. Displays information about crafts and celestial bodies. TWR displayed is relative to polar gravity for Mesbin, which is about 10 times higher than the apparent equatorial gravity, so keep that in mind when building.
* Github Repository: https://github.com/jrbudda/KerbalEngineer/releases

Waterfall. New shader for KSP rocket plumes. Changes rocket engine exhaust to look different in a vacuum compared to in the atmosphere, by showing the broader expansion of exhaust gasses.
* Forum Thread: https://forum.kerbalspaceprogram.com/index.php?/topic/196309-111x-waterfall-a-framework-for-continuous-mesh-driven-engine-effects-march-26/

Better Timewarp. Adds better timewarp controls including faster maximum timewarp, which is necessary when maneuvering around the outer system.
* Forum Thread: https://forum.kerbalspaceprogram.com/index.php?/topic/154935-15-bettertimewarpcontinued-customizable-time-warp-and-lossless-physics-warp/

SMURFF. Simple Module adjUstments for Real-ish Fuel-mass Fractions. It makes rocket parts lighter, so that stock parts can be used in Real Solar System instead of Realism Overhaul. However, it may be useful here given Mesbin's high escape velocity! I personally don't use it, but if you feel that WW is too hard with default mass ratios, you may want to give SMURFF a try!
* Forum Thread: https://forum.kerbalspaceprogram.com/index.php?/topic/117992-14x-smurff-simple-module-adjustments-for-real-ish-fuel-mass-fractions-180-02018-mar-21/

Atomic Age/Spacetux Recycled Parts. Porkjet's original Nuclear Lightbulb and LANTR nuclear rockets are a nice, slightly more stockalike alternative to Kerbal Atomics, and the nuclear ramjet is handy for exploring some of the non-oxidized atmospheres of the planets in the system.
* Forum Thread: https://forum.kerbalspaceprogram.com/index.php?/topic/164829-13-14-spacetux-industries-recycled-parts/

------------------------------------------------------------------

Contact:

* Twitter: @GregroxMun
* Kerbal Space Program Forums: GregroxMun https://forum.kerbalspaceprogram.com/index.php?/profile/36077-gregroxmun/

------------------------------------------------------------------

Conclusion:

I hope you enjoy playing in this absurd system! I have certainly enjoyed making it.

I encourage you to post your mission reports on the mission reports forums and/or the KSP subreddit. For real time discussion, visit my [Discord server](https://discord.gg/ffzJqEs) where you can find prerelease builds and development updates. I'd love to see someone do a youtube or twitch career mode series with this mod. If you make a video of this mod or see a video of this mod, let me know!

