﻿using System;
using System.Collections.Generic;

namespace kujutils
{
    public class ActionGroupThrottleLimit : PartModule
    {
        public struct EnginePair
        {
            public ModuleEngines engine;
            public float limit;

            public EnginePair(ModuleEngines e)
            {
                engine = e;
                limit = 100;
            }
        }
        public struct EngineFXPair
        {
            public ModuleEnginesFX engine;
            public float limit;

            public EngineFXPair(ModuleEnginesFX e)
            {
                engine = e;
                limit = 100;
            }
        }

        public List<EnginePair> engines;
        public List<EngineFXPair> engineFXs;

        [KSPField(guiName = "Limiter", isPersistant = true, guiActive = true),
            UI_Toggle(disabledText = "Disabled",
            scene = UI_Scene.All,
            enabledText = "Enabled",
            affectSymCounterparts = UI_Scene.Editor)]
        public bool throttleLimited = false;

        [KSPField(guiName = "Action Throttle Limit", isPersistant = true, guiActive = true),
            UI_FloatRange(minValue = 0f,
            stepIncrement = 1f,
            maxValue = 100f,
            affectSymCounterparts = UI_Scene.All)]
        public float throttleLimit = 100f;

        [KSPAction("Toggle Throttle Limit")]
        public void ToggleAction(KSPActionParam param)
        {
            if (throttleLimited)
            {
                ReleaseAction(param);
            }
            else
            {
                SetAction(param);
            }
        }

        [KSPAction("Limit Engine 0", advancedTweakable = true)] public void Engine0(KSPActionParam param) { if (throttleLimited) { ReleaseAction(param); } SetLimit(0); }
        [KSPAction("Limit Engine 5", advancedTweakable = true)] public void Engine5(KSPActionParam param) { if (throttleLimited) { ReleaseAction(param); } SetLimit(5); }
        [KSPAction("Limit Engine 10", advancedTweakable = true)] public void Engine10(KSPActionParam param) { if (throttleLimited) { ReleaseAction(param); } SetLimit(10); }
        [KSPAction("Limit Engine 15", advancedTweakable = true)] public void Engine15(KSPActionParam param) { if (throttleLimited) { ReleaseAction(param); } SetLimit(15); }
        [KSPAction("Limit Engine 20", advancedTweakable = true)] public void Engine20(KSPActionParam param) { if (throttleLimited) { ReleaseAction(param); } SetLimit(20); }
        [KSPAction("Limit Engine 25", advancedTweakable = true)] public void Engine25(KSPActionParam param) { if (throttleLimited) { ReleaseAction(param); } SetLimit(25); }
        [KSPAction("Limit Engine 30", advancedTweakable = true)] public void Engine30(KSPActionParam param) { if (throttleLimited) { ReleaseAction(param); } SetLimit(30); }
        [KSPAction("Limit Engine 35", advancedTweakable = true)] public void Engine35(KSPActionParam param) { if (throttleLimited) { ReleaseAction(param); } SetLimit(35); }
        [KSPAction("Limit Engine 40", advancedTweakable = true)] public void Engine40(KSPActionParam param) { if (throttleLimited) { ReleaseAction(param); } SetLimit(40); }
        [KSPAction("Limit Engine 45", advancedTweakable = true)] public void Engine45(KSPActionParam param) { if (throttleLimited) { ReleaseAction(param); } SetLimit(45); }
        [KSPAction("Limit Engine 50", advancedTweakable = true)] public void Engine50(KSPActionParam param) { if (throttleLimited) { ReleaseAction(param); } SetLimit(50); }
        [KSPAction("Limit Engine 55", advancedTweakable = true)] public void Engine55(KSPActionParam param) { if (throttleLimited) { ReleaseAction(param); } SetLimit(55); }
        [KSPAction("Limit Engine 60", advancedTweakable = true)] public void Engine60(KSPActionParam param) { if (throttleLimited) { ReleaseAction(param); } SetLimit(60); }
        [KSPAction("Limit Engine 65", advancedTweakable = true)] public void Engine65(KSPActionParam param) { if (throttleLimited) { ReleaseAction(param); } SetLimit(65); }
        [KSPAction("Limit Engine 70", advancedTweakable = true)] public void Engine70(KSPActionParam param) { if (throttleLimited) { ReleaseAction(param); } SetLimit(70); }
        [KSPAction("Limit Engine 75", advancedTweakable = true)] public void Engine75(KSPActionParam param) { if (throttleLimited) { ReleaseAction(param); } SetLimit(75); }
        [KSPAction("Limit Engine 80", advancedTweakable = true)] public void Engine80(KSPActionParam param) { if (throttleLimited) { ReleaseAction(param); } SetLimit(80); }
        [KSPAction("Limit Engine 85", advancedTweakable = true)] public void Engine85(KSPActionParam param) { if (throttleLimited) { ReleaseAction(param); } SetLimit(85); }
        [KSPAction("Limit Engine 90", advancedTweakable = true)] public void Engine90(KSPActionParam param) { if (throttleLimited) { ReleaseAction(param); } SetLimit(90); }
        [KSPAction("Limit Engine 95", advancedTweakable = true)] public void Engine95(KSPActionParam param) { if (throttleLimited) { ReleaseAction(param); } SetLimit(95); }
        [KSPAction("Limit Engine 100", advancedTweakable = true)] public void Engine100(KSPActionParam param) { if (throttleLimited) { ReleaseAction(param); } SetLimit(100); }


        public void SetLimit(float target)
        {
            for (int i = 0; i < engines.Count; i++)
            {
                engines[i].engine.thrustPercentage = target;
            }
            for (int i = 0; i < engineFXs.Count; i++)
            {
                engineFXs[i].engine.thrustPercentage = target;
            }
        }

        [KSPAction("Set Limiter")]
        public void SetAction(KSPActionParam param)
        {
            this.throttleLimited = true;
            print("There are " + engines.Count + " engines");

            for (int i = 0; i < engines.Count; i++)
            {
                var e = engines[i];
                e.limit = engines[i].engine.thrustPercentage;
                engines[i].engine.thrustPercentage = throttleLimit;
            }
            for (int i = 0; i < engineFXs.Count; i++)
            {
                var e = engineFXs[i];
                e.limit = engineFXs[i].engine.thrustPercentage;
                engineFXs[i].engine.thrustPercentage = throttleLimit;
            }
        }

        [KSPAction("Release Limiter")]
        public void ReleaseAction(KSPActionParam param)
        {
            this.throttleLimited = false;
            foreach (EnginePair e in engines)
            {
                e.engine.thrustPercentage = e.limit;
            }
            foreach (EngineFXPair e in engineFXs)
            {
                e.engine.thrustPercentage = e.limit;
            }
        }

        private void BuildEngineArrays()
        {
            engines = new List<EnginePair>();
            engineFXs = new List<EngineFXPair>();

            foreach(ModuleEngines e in this.part.Modules.GetModules<ModuleEngines>())
            {
                var ep = new EnginePair(e);
                engines.Add(ep);
            }

            foreach (ModuleEnginesFX e in this.part.Modules.GetModules<ModuleEnginesFX>())
            {
                var ep = new EngineFXPair(e);
                engineFXs.AddUnique(ep);
            }
        }

        public override void OnStart(PartModule.StartState state)
        {
            BuildEngineArrays();
        }

        public override void OnLoad(ConfigNode node)
        {
            BuildEngineArrays();
        }

    }
}

