# KDEX Continued

*Kerbal Dust Experiment* by **masTerTorch** for [Kerbal Space Program](http://kerbalspaceprogram.com)

[![ReleaseShield]][release] [![KSPShield]][KSP] [![CKANShield]][CKAN] [![SourceShield]][GitHub] [![LicenseShield]][License]

[ReleaseShield]: https://img.shields.io/github/v/release/mwerle/kdex?include_prereleases
[KSPShield]: https://img.shields.io/badge/KSP%20version-1.11.x-66ccff.svg?style=flat-square
[CKANShield]: https://img.shields.io/badge/CKAN-Indexed-brightgreen.svg
[SourceShield]: https://img.shields.io/badge/source%20code-github-yellowgreen
[LicenseShield]: https://img.shields.io/badge/license-CC%20BY--NC--SA%203.0-lightgrey

***

## About
The *Kerbal Dust Experiment* by masTerTorch is a replica of [LADEE]s [LDEX] instrument. It comes with an animated model and many individualised science results.

Inspired by the [NASA] mission [LADEE]. The objective of [LADEE] was to investigate the mysteries of the lunar atmosphere and the question of levitated lunar dust. It carried a scientific instrument called the Lunar Dust Experiment ([LDEX]). This instrument was an impact ionization dust detector. In this way it was possible to measure the density of dust particles.

Kerbals are known for impacts and collisions and since 0.22 they do science. KDEX combines impacts and science.

This part is giving you the opportunity to do science the Kerbal way!

[NASA]: http://nasa.gov
[LADEE]: https://www.nasa.gov/mission_pages/ladee/main/index.html
[LDEX]: https://www.nasa.gov/mission_pages/ladee/science/index.html

### Content

 - One new science experiment model. (KDEX - Can be unlocked in the tech tree. Node: Space Exploration)
 - Individualised science results strings for many different situations.
 
### Translations
From v2.0 onwards, KDEX supports localisation.  So far, the following languages are supported:

 - english (US)
 - german
 - russian
 - spanish

## Installation Instructions
1. Unzip
2. Copy the folder "masTerTorch" into your "KSP/GameData" folder.
3. Play
4. KDEX is part of the "Space Exploration" tech node.

## License
This mod is licensed under the [CC BY-NC-SA 3.0][License] license; effectively it means it's free to use and modify for non-commercial usage as long as the original author(s) are attributed.

[![CC BY-NC-SA 3.0](https://licensebuttons.net/l/by-nc-sa/3.0/88x31.png)][License]

## Resources
* Source code
  + [GitHub]
* Forum threads
  + [Micha's Release Thread](http://forum.kerbalspaceprogram.com/index.php?showtopic=166619)
  + [masTerTorch's original Thread](http://forum.kerbalspaceprogram.com/index.php?showtopic=50039)
* Download Links
  + [GitHub][Release]
  + [SpaceDock](http://spacedock.info/mod/1551)
  + [CurseForge](https://www.curseforge.com/kerbal/ksp-mods/kdex-continued)

<!-- URLs -->
[License]: https://creativecommons.org/licenses/by-nc-sa/3.0/
[CKAN]: https://github.com/KSP-CKAN/CKAN
[GitHub]: http://github.com/mwerle/kdex
[Release]: http://github.com/mwerle/kdex/releases/latest
[KSP]: http://www.kerbalspaceprogram.com
