RCS Build Aid Plugin
====================
Elián Hanisch <lambdae2@gmail.com>
v0.9.2, Oct 14, 2017, by LinuxGuruGamer

Aid tool for balancing RCS thrusters around the center of mass while building a
rocket, and a bit more.

Requirements
------------

* KSP version 1.4.1

* ToolbarController
* ClickThroughBlocker


Optional
~~~~~~~~

* blizzy78's toolbar http://forum.kerbalspaceprogram.com/threads/60863
* KSP-AVC Plugin for update notifications http://forum.kerbalspaceprogram.com/threads/79745
 
Installation
------------

Just copy RCSBuildAid directory into your KSP's GameData directory. 

**** For 0.9.6 and beyond, you must also install the ToolbarController and the ClickThroughBlocker

Features
--------

* Display thrust and torque forces caused by RCS or engines.
* Torque by engine gimbals.
* Delta V readout for MonoPropellant RCS.
* Dry center of mass marker (DCoM).
* Center of drag marker (CoD) for parachute placement.
* Average center of mass marker (ACoM).
* Ability to resize editor's overlay markers.
* Display total amount/mass of resources.

Files
-----

These are the files that comprises RCS Build Aid.

* Plugins/
** RCSBuildAid.dll _The main plugin._
** RCSBuildAidToolbar.dll _This plugin adds support for blizzy78's toolbar, and can be deleted if you don't use it._
** PluginData/
*** settings.cfg _RCS Build Aid config, can be deleted for reset all settings._
* Textures/
** iconAppLauncher.png
** iconToolbar_active.png
** iconToolbar.png
* CHANGELOG.asciidoc
* README.asciidoc
* LICENSE
* RCSBuildAid.version _File used by some tools for check for updates, such as KSP-AVC plugin._

Usage
-----

This plugin can only be used while in VAB (Vehicular Assembly Building) or in 
SPH (Space Plane Hangar). RCSBuildAid is be enabled from the application 
launcher at the bottom of the screen. Once enabled, you should see RCSBuildAid's
window. You can also enable it with a keyboard shortcut, see Settings section.

NOTE: If you have blizzy78's toolbar installed, then you can disable the 
application launcher button or blizzy78's toolbar from the settings menu.

Balancing RCS
~~~~~~~~~~~~~

Having balanced RCS means that when you're translating your vessel won't rotate 
and when you are rotating it won't translate, this is important for easy 
docking. This depends of the position of your CoM and the placement of your RCS 
thrusters.

Mode selection
~~~~~~~~~~~~~~

The topmost button in the window is for select the working mode, each having a 
different purpose. Currently the modes available are:

==== Translation

For balancing translation. The installed RCS will be set to translate your 
vessel to the current direction, with the green arrow being the actual resulting 
motion. When balancing translation you want translation motion without any 
rotation, so you want to place your RCS around your CoM in a way that reduces 
the torque vector (red arrow) as much as possible.

NOTE: Is not necessary to completely cancel out the torque force, sometimes 
might be difficult. If you don't see the circular arrow then it means that the
current torque is acceptable and shouldn't interfere during normal docking.

==== Attitude

For balancing attitude. Only with RCS, reaction wheels and engine's gimbals not 
accounted. For balancing attitude you want to reduce the translation vector 
(green arrow) while keeping the torque vector aligned with the red marker. In 
most vessels you won't need to do this since balanced translation implies 
balanced rotation, but this is not always true.

==== Engines

For balancing engine's thrust. The engines used in the calculation are always 
the engines in the bottommost stage, if you want to disable some engines you can 
move them to a higher stage.
This mode also allows changing the direction of gimbals, showing their produced
torque.

==== Parachutes

For balancing parachutes. This mode activates the center of drag (CoD) marker and
should help in positioning parachutes so that your vessel will touchdown with the
desired attitude and velocity.

NOTE: Parachutes' drag vectors vary in both magnitude and direction, this is not 
modelled by RCSBA so its indications are not completely accurate.

Editor overlays
~~~~~~~~~~~~~~~

==== Forces

The forces displayed are of 3 types:

Part forces::
Forces exerted by parts, they are colored cyan for RCS and yellow for engines.

Translation force or thrust::
Colored in green, represents the translation motion of your vessel, essentially 
your vessel's thrust. A small green triangle near the tip of the arrow indicates 
where it should be pointing ideally.

Torque force::
Colored in red, represents the resulting torque the thrusters are exerting into 
your vessel. The effect of this torque is represented by a circular arrow, 
which is proportional to the expected angular acceleration. 
When you see a red arrow, it means that in the current configuration and with 
the given input your vessel will try to rotate, however, depending of your 
vessel's mass and of its distribution this rotation might not be noticeable, 
you can gauge this with the circular arrow. Like in the translation force, a 
small red triangle would be indicating the ideal direction.

==== Markers

CoM::
The Center of Mass marker, colored yellow. You should be familiar with this 
one.

DCoM::
The Dry Center of Mass marker, colored red, indicates the center of mass for
your vessel without resources. Which resources to remove when the vessel is 
"dry" can be configured from the `Resources` settings.

ACoM::
This is the Average Center of Mass marker, colored orange, shows the middle 
point between the CoM and DCoM.

All forces are referenced to one of these markers, you select which one from the 
GUI. Checking how forces change depending of where your CoM is will help you to 
understand how to balance best your vessel, eg, for a vessel that docks with 
almost no fuel it would be best to balance RCS around the DCoM and ignore the 
CoM marker. If you want your vessel to be balanced in most situations you need 
to build your vessel in a way that keeps both center of masses as close as 
possible, or if you can't achieve this, balancing around the ACoM marker would 
be the best compromise.

CoD::
The Center of Drag, only enabled while in parachute mode. Shows the resultant
drag force.

User interface
~~~~~~~~~~~~~~

RCS Build Aid's window have several sections showing some information and 
options.

==== Select mode

Shows some information regarding the current mode in use, usually the thrust 
and torque magnitudes, and buttons for change the current direction and center 
of mass (CoM, DCoM or ACoM).

Torque::
    Torque magnitude.

Thrust::
    Thrust magnitude. In engine mode, there's a toggle for select between 
    thrust at vacuum or at sea level of the selected planet.

Reference::
    Active center of mass of the vessel, click for change.

Direction (Translation mode)::
    Current movement direction, click for change or use the shortcuts.

Rotation (Attitude and Engine modes)::
    Similar to direction, but for attitude changes. In Engine mode there
    will be an "R" button for reset gimbals position.

ΔV (Translation mode only)::
    Available delta velocity from RCS at current direction.

NOTE: The delta V readout has some issues, see Known issues section.

Burn time (Translation mode only)::
    Time RCS will last until running out of fuel at current direction.

Body (Engine mode only)::
    Selected body for TWR calculations, click for change.

TWR (Engine mode only)::
    Thrust to weigth ratio at sea level of the selected celestial body.

Vt (Parachute mode only)::
    Terminal velocity of the vessel for the selected planet and altitude.

==== Vessel mass

Shows some information regarding the mass of the vessel.

Wet Mass::
    Total mass of the fully fueled vessel.

Dry Mass/Fuel Mass::
    Mass of the vessel without fuel / Mass of the fuel, click in label to toggle.

==== Resources

Shows a list of resources currently in your vessel, displaying the total mass 
or the total amount of each (click in the "Mass" label for change the reading). 

You can select which resources should be used for calculating the DCoM position 
and the vessel's dry mass, disabled resources will be removed and enabled ones 
will remain. For example, if you want to know your vessel's mass and DCoM 
position when only the MonoPropellant is completely consumed, only disable the 
MonoPropellant.

==== Markers

Options for show, hide or change the size of the CoM markers.

==== Settings

You can open the settings menu from the small 's' button in the title bar of 
RCSBuildAid window.

Use application launcher:: 
    Disable/Enable RCSBuildAid's button in the application launcher.

Use blizzy's toolbar::
    Disable/Enable RCSBuildAid's button in blizzy's toolbar.

Show in Action Groups::
    Don't hide RCSBuildAid when switching to the action groups screen in the 
    editor.

Marker autoscaling::
    The CoM markers will change size depending of the camera distance (if you 
    get the camera closer to your vessel the markers will shrink).

Shortcut::
    Enable RCSBuildAid with a keyboard shortcut, disabled by default. You might
    assign any key but no key combinations. Using ESC disables it.

Keyboard shortcuts
~~~~~~~~~~~~~~~~~~

You can change direction from the GUI, or alternatively with the same keys for 
translating your vessel.

*For translation mode:*

[horizontal]
H :: Set direction towards fore (forward).
N :: Set direction towards aft (backward).
L :: Set direction towards starboard (right).
J :: Set direction towards port (left).
I :: Set direction towards ventral (down).
K :: Set direction towards dorsal (up).

*For Attitude and Engine mode:*

[horizontal]
H :: Set rotation to roll left.
N :: Set rotation to roll right.
L :: Set rotation to yaw right.
J :: Set rotation to yaw left.
I :: Set rotation to pitch down.
K :: Set rotation to pitch up.

NOTE: Using the keys when no mode is enabled will automatically enable 
translation or the last used mode. Setting the same direction twice disables
current mode.

Incompatible plugins
--------------------

This plugin will work only with parts using stock modules, such as `ModuleRCS` 
or `ModuleEngine`. Modded parts that use other modules will not be detected by
RCS Build Aid.

Known Issues
------------

* Delta V readout for RCS isn't very smart and only works for the stock RCS that
use monopropellant, there will be no dV readout if the RCS uses other fuel or a
different flow mode (like Vernor RCS).
* Parachute mode only works with stock aerodynamics and parachutes, will not work
with mods such as `FerramAerospaceResearch` and `RealChute`.

Compiling
---------

Make
~~~~

Before compiling with make, you need to create an enviroment variable pointing
KSP instalation:
 
 export KSPDIR=/home/user/KSP
 make


MonoDevelop
~~~~~~~~~~~

This project picks its references for a local directory for avoid commiting the 
absolute path of library files into the repository. So if you want this project 
to find its references without changing any project files you have create a 
local directory named `Libraries` and copy (or symlink) the directory `Managed` 
from a KSP install and `Toolbar.dll` from blizzy78's toolbar mod (if you wish to 
compile `RCSBuildAidToolbar.dll`).

  Libraries\
    Managed -> ${KSP_DIR}/KSP_Data/Managed
    Toolbar.dll -> ${KSP_DIR}/GameData/000_Toolbar/Toolbar.dll

Reporting Bugs
--------------

You can report bugs or issues directly to GitHub:
https://github.com/m4v/RCSBuildAid/issues

Links
-----

Curse site:
http://curse.com/project/220602

Repository in GitHub:
https://github.com/m4v/RCSBuildAid

Forum thread:
http://forum.kerbalspaceprogram.com/threads/35996

License
-------

This plugin is distributed under the terms of the LGPLv3.

---------------------------------------
This program is free software: you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
---------------------------------------
