RoverScience Continued
============

Original mod by theSpeare continued by Aelfhe1m



RoverScience is a KSP plugin that attempts to add more interactive functionality to the science system FOR rovers. You drive rovers to search for *science spots* which you may then decide to investigate and analyze for science gain.


## Quick Instructions

[1] Build your rover and attach the Rover Brain and ensure it is pointing "forward". As long as it is pointing "forward" it can be placed anywhere on your rover. **This forward orientation is not critical to the functioning of RoverScience, but it will provide you with a convenient "Control From Here" for driving the rover correctly forward.**
![image](readme/h23aQHM.png)
[2] Right-click on the Rover Brain in-flight and click "Activate Rover Terminal".

![image](readme/VaLEFWz.png)
[3] This console will update you with information regarding the Rover Brain. Drive and explore around to search for a science spot.

![image](readme/PkUaLyB.png)
[4] After driving for awhile, you may detect a potential science spot. This will be shown as a large red transparent sphere waypoint. Drive towards the waypoint to further investigate.

![image](readme/Q5T06vL.png)
[5] Drive into the marker and it will turn green. You may now analyze for science, but before you do consider the potential science. **Every science spot analysis will increase future science loss; be wise with which spots you wish to analyze, and which to abandon.** At any point you may click on "Reset Science Spot" to begin search for another spot.

![image](readme/6uRo3Zy.png)
[6] This is the upgrade menu. "Current" shows you what value an upgrade currently has. "Next" will show you the value if you increase the level. "Cost" is how much you will spend in science to upgrade. "UP" is the button to upgrade. An explanation of each of the upgrades is given further below.

![image](readme/37ssbHz.png)


## RoverScience Upgrades

### Prediction Accuracy

**Science spots** have a "science potential" containing of "very low" or up to "very high" science. **The player must drive to the science spot physically to receive the full, accurate science potential reading.**

However RoverScience can provide a prediction on the **science spot**'s potential while still away. The accuracy/confidence of the prediction is based on the upgrade "Prediction Accuracy". The player should increase the accuracy level in order to fully trust the prediction reading, as the prediction could be completely wrong.

This is important to save player time from driving to **science spots** that do not have a decent enough potential.

### Max Scan Distance

**Science spots** farther away from the rover will carry a bonus multiplier. Generally speaking, the farther away you detect science spots, the more science you will get in return. **However this is not always the best case scenario**. 200% of 10 science is **20**. This is where prediction accuracy will come in handy; with good predictions, the player may choose to avoid driving to spots far away in order to save time.

The player can set the scan range on the rover terminal as seen below. Simply input the range in distance and click the button.

![image](readme/GyvJnUK.png)


### Analyzed Decay Limit

**Every science spot analysis will increase future science loss; be wise with which spots you wish to analyze, and which to abandon.**
Initially, rovers are only able to analyze **two** science spots before beginning to suffer science loss. The player may improve re-usability by upgrading this in the upgrade menu. This mod encourages players to build, and send out more rovers, and so the science costs for this upgrade (as of the time of this writing) will probably be ridiculous.

**All upgrades are permanent and work across all rovers!**

## Notes:

- Firstly, RoverScience will not function unless the Rover Terminal is opened. This is done through the right-click menu of the Rover Brain part.
- RoverScience will only search for science spots if your vessel has at least one wheel, and that it is in contact with the ground.
- Upon landing, your rover will establish a **landing spot**. Driving farther away from where you originally landed will increase chances of _finding a **science spot**_.
- **Science spots** detected far away from the _rover_ will have a bonus multiplier added to them. You are rewarded for exploring and reaching far destinations. Bear in mind that a 50% increase to 10 is only 15 -> carefully consider whether the potential (or the prediction) is worth it.
- Each analysis you commit to will slowly degrade a rover's return of science. For the first 2 analyses you'll get normal values, and anything past that will slowly degrade the amount of science you get back. Soak up those high potentials as much as possible!
- CTRL + R + S will open the RoverScience menu.

## Credits

* Original mod coding by [theSpeare ](http://forum.kerbalspaceprogram.com/index.php?/profile/62144-thespeare/)
* [etmoonshade](http://forum.kerbalspaceprogram.com/index.php?/profile/1852-etmoonshade/)
* [udk_lethal_dose](http://forum.kerbalspaceprogram.com/index.php?/profile/62149-udk_lethal_d0se/)
* [akron](http://forum.kerbalspaceprogram.com/index.php?/profile/116554-akron/) for Rover Brain parts - modelling and texturing
* Nat Sum for rock models!
* Spanish translation by [fitiales](http://forum.kerbalspaceprogram.com/index.php?/profile/66011-fitiales/)
* German translation by [Three_Pounds](https://forum.kerbalspaceprogram.com/index.php?/profile/116058-three_pounds/)

## License

![CC BY-NC-SA](http://i.creativecommons.org/l/by-nc-sa/3.0/88x31.png)
This work is licensed under a [Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License](http://creativecommons.org/licenses/by-nc-sa/3.0/deed.en_GB).
