Nehemia Engineering Orbital Science (NEOS)
==========================================

(WAS: Orbital Material Science)
-------------------------------

Overview
--------

This is really a collection of several mods which all have a common theme - orbital experiments.

There are 4 major components:

1. **Kemini** - In-capsule experiments for the MK1 pod intended for very early career mode play.

2. **KEES** - Kerbal Environmental Effects Study

   This set of experiments uses an external carrier (which must be attached in-orbit using KIS) onto which exposure experiments can be loaded (again using KIS). It is intended to be attached to a small orbital station with different experiments launched and installed over time.
   
   Components can be brought to orbit using either a special carrier included in the mod, or standard KIS containers.
    
3. **OMS** - Orbital Material Sciences

   This set of experiments is the most ambitious, requiring various stages to complete and is intended for large, long-duration orbital complexes.

   First, an orbital Lab must be launched. There are three labs, an MPL-600, MSL-1000, and MEP-825.  Each lab (except for the MEP-825) needs to have lab equipment installed in it (which must be launched separately) before experiments can be installed and run. Lab equipment is specific to a lab, and experiments are specific to lab equipment - so ensure you have the correct equipment before launching experiments!
   
4. **KLS** - Kerbal Life Sciences

   Additional equipment and experiments for the MPL-600 lab.
   
   Similar to OMS it requires launching a lab, equipment, and experiments in order to perform the science. Instead of standalone experiments, these also require Kerbals to experiment on, so ensure you bring enough ~~victims~~ subjects along!

Each component can be downloaded and installed separately, or the entire collection can be downloaded as one mod.


Changes
-------

Please see the [Changelog](CHANGELOG.md) for a version history and overview of changes. For the full details, please see the GitHub commit log.


Contributing
------------

Please see the [Contribution Guidelines for this project](Contributing.md) which provide an overview of how this project is laid out and how to support it.

Also make sure you agree with the [Project License](LICENSE) before starting any work.

A list of contributors can be [found here](CONTRIBUTORS.md).

Resources
---------

* [Micha's Release forum thread](http://forum.kerbalspaceprogram.com/index.php?showtopic=149298) covers my maintenance build releases and a brief usage summary of the mod, with links to downloads and other resources.

  * **N3h3miah**'s original [Forum Thread](http://forum.kerbalspaceprogram.com/index.php?showtopic=73723) contains an in-depth overview and explanation of the mod, **with screenshots**!

* [Micha's Builds forum thread](http://forum.kerbalspaceprogram.com/index.php?showtopic=106924) covers my maintenance builds of this mod while Nehemia is MIA.

Requirements
------------

* Kemini requires the [ModuleManager](https://github.com/sarbian/ModuleManager) mod.

* KEES requires the [KIS](https://github.com/KospY/KIS) mod.

The remaining components are standalone, although may be enhanced by ModuleManager.

Related and Recommended Mods
----------------------------

* [K2 Command Pod](http://forum.kerbalspaceprogram.com/index.php?showtopic=94581) - works very well with Kemini and KEES.

* [Corvus Command Pod](http://forum.kerbalspaceprogram.com/index.php?showtopic=163101) - works very well with Kemini and KEES.

* [Kerbal Alarm Clock](https://forum.kerbalspaceprogram.com/index.php?showtopic=22809) - _very_ useful when managing multiple missions while leaving experiments running in the background.

* [Universal Storage](http://www.kingtiger.co.uk/kingtiger/wordpress/universal-storage-a-mod-for-kerbal-space-program/) - when installed, additional US wedges are available for storing experiments.

* [Connected Living Spaces](https://github.com/codepoetpbowden/ConnectedLivingSpace) - various parts are compatible with CLS and allow Kerbals to move through them.

* [Custom Bulkhead Profiles](https://forum.kerbalspaceprogram.com/index.php?showtopic=181645) - supplies additional bulkhead profile descriptions used by NEOS.

Download Links
--------------

* [GitHub](https://github.com/mwerle/OrbitalMaterialScience/releases) - primary download location.

* [SpaceDock](https://spacedock.info/mod/1393)

* [CurseForge](https://mods.curse.com/ksp-mods/kerbal/270269-neos)

* And via the [CKAN](https://forum.kerbalspaceprogram.com/threads/100067) tool.
