﻿using System;
using System.Collections.Generic;
using System.Linq;
using UnityEngine;

namespace SpaceLink
{
    [KSPAddon(KSPAddon.Startup.MainMenu, false)]
    public class SpaceLink : MonoBehaviour
    {
        void Start()
        {
            foreach (MainMenu m in Resources.FindObjectsOfTypeAll<MainMenu>())
            {
                m.SpaceportURL = "https://spacedock.info/kerbal-space-program";
            }
        }
    }

    [KSPAddon(KSPAddon.Startup.Instantly, false)]
    public class PizzaDock : MonoBehaviour
    {
        void Awake()
        {
            foreach (LoadingScreen.LoadingScreenState s in LoadingScreen.Instance.Screens)
            {
                List<String> tips = s.tips.ToList();
                tips.Add("Ordering pizza...");
                s.tips = tips.ToArray();
            }
        }
    }
}
